// PrinterSettings.cpp : implementation file
//

#include "stdafx.h"
#include "afxdialogex.h"
#include "windows.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "PrinterSettings.h"
#include "Infopage.h"
#include "Encoding.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "PrintDemo.h"

//#############################################################################

// CPrinterSettings dialog

IMPLEMENT_DYNAMIC(CPrinterSettings, CPropertyPage)

CPrinterSettings::CPrinterSettings()
	: CPropertyPage(CPrinterSettings::IDD)
	, PrinterAction(0)
{
	//Create other tab pages
	InfoPage	 = new CInfoPage;
	EncodingPage = new CEncoding;  
	DriverPage1  = new CDriverSettings1;
	DriverPage2  = new CDriverSettings2;
	PrintPage	 = new CPrintDemo;
	UtilsPage	 = new CUtilsPage;
}

CPrinterSettings::~CPrinterSettings()
{
	//Remove the other tabs
	delete InfoPage;
	delete EncodingPage;
	delete DriverPage1;
	delete DriverPage2;
	delete PrintPage;
	delete UtilsPage;
}

void CPrinterSettings::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_OPENSESSION, OpenSessionBtn);
	DDX_Control(pDX, IDC_OPENSESSION_COMBO, OpenSessionCombo);
	DDX_Control(pDX, IDC_BTN_CLOSESESSION, CloseSessionBtn);
	DDX_Control(pDX, IDC_BTN_PRINTTESTCARD, TestCardBtn);
	DDX_Control(pDX, IDC_BTN_CLEANPRINTER, CleanBtn);
	DDX_Control(pDX, IDC_BTN_RESTARTPRINTER, RestartBtn);
	DDX_Control(pDX, IDC_GENERALMSG, GeneralMessage);
	DDX_Control(pDX, IDC_BTN_ERRORRESPONSE, ErrorRespBtn);
	DDX_Control(pDX, IDC_ERRORRESPONSE_COMBO, ErrorRespCombo);
	DDX_Control(pDX, IDC_EJECTMODE_COMBO, EjectModeCombo);
	DDX_Control(pDX, IDC_BTN_EJECTMODE, EjectModeBtn);
	DDX_Control(pDX, IDC_BTN_IPSETTINGS, IPSettingsBtn);
	DDX_Control(pDX, IDC_IPADDRESSMODE_COMBO, IPModeCombo);
	DDX_Control(pDX, IDC_IPADDRESS, IPAddress);
	DDX_Control(pDX, IDC_IPADDR_SUBNET, IPSubnet);
	DDX_Control(pDX, IDC_IPADDR_GATEWAY, IPGateway);
	DDX_Control(pDX, IDC_GETACTIONRADIO, PrinterGet);
	DDX_Control(pDX, IDC_SETACTIONRADIO, PrinterSet);
	DDX_Radio(pDX,   IDC_GETACTIONRADIO, PrinterAction);
	DDV_MinMaxInt(pDX, PrinterAction, 0, 1);
	DDX_Control(pDX, IDC_BTN_MOVECARD, MoveCardBtn);
	DDX_Control(pDX, IDC_MOVEMODE_COMBO, MoveCardCombo);
}

BEGIN_MESSAGE_MAP(CPrinterSettings, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_OPENSESSION,     &CPrinterSettings::OnBnClickedBtnOpenSession)
	ON_BN_CLICKED(IDC_BTN_CLOSESESSION,    &CPrinterSettings::OnBnClickedBtnCloseSession)
	ON_BN_CLICKED(IDC_BTN_PRINTTESTCARD,   &CPrinterSettings::OnBnClickedBtnPrintTestCard)
	ON_BN_CLICKED(IDC_BTN_CLEANPRINTER,    &CPrinterSettings::OnBnClickedBtnCleanPrinter)
	ON_BN_CLICKED(IDC_BTN_RESTARTPRINTER,  &CPrinterSettings::OnBnClickedBtnRestartPrinter)
	ON_BN_CLICKED(IDC_BTN_ERRORRESPONSE,   &CPrinterSettings::OnBnClickedBtnErrorResponse)
	ON_BN_CLICKED(IDC_BTN_EJECTMODE,       &CPrinterSettings::OnBnClickedBtnEjectMode)
	ON_BN_CLICKED(IDC_GETACTIONRADIO,      &CPrinterSettings::OnBnClickedGetActionRadio)
	ON_BN_CLICKED(IDC_SETACTIONRADIO,      &CPrinterSettings::OnBnClickedSetActionRadio)
	ON_BN_CLICKED(IDC_BTN_IPSETTINGS,      &CPrinterSettings::OnBnClickedBtnIPSettings)
	ON_BN_CLICKED(IDC_BTN_GENERALMSG_CLR,  &CPrinterSettings::OnBnClickedBtnGeneralMsgClr)
	ON_BN_CLICKED(IDC_BTN_MOVECARD,        &CPrinterSettings::OnBnClickedBtnMoveCard)
END_MESSAGE_MAP()

//#############################################################################

BOOL CPrinterSettings::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();
	OpenSessionCombo.SetCurSel(0);

	ErrorRespCombo.SetCurSel(0);
	MoveCardCombo.SetCurSel(0);
	EjectModeCombo.SetCurSel(0);

	//Get the current filename
    TCHAR pFileName[MAX_PATH];
	if (GetModuleFileName(NULL, pFileName, MAX_PATH) > 0)
	{
		// Get the file version info size
		DWORD dwSize = GetFileVersionInfoSize(pFileName, NULL);
		if (dwSize != 0)
		{
			// Get the Version Info
			BYTE *pVersionInfo = new BYTE[dwSize];
			if (GetFileVersionInfo(pFileName, 0, dwSize, pVersionInfo))
			{
				//Query the specific Version information
				VS_FIXEDFILEINFO *pFileInfo = NULL;
				UINT pLenFileInfo = 0;
				if (VerQueryValue(pVersionInfo, _T("\\"), (LPVOID*) &pFileInfo, &pLenFileInfo))
				{
					//Output the application version number to the display
					CString temp;
					temp.Format(_T("%d.%d.%d.%d"),
								HIWORD(pFileInfo->dwFileVersionMS),
								LOWORD(pFileInfo->dwFileVersionMS),
								HIWORD(pFileInfo->dwFileVersionLS),
								LOWORD(pFileInfo->dwFileVersionLS));
					AddGeneralMessage(_T("Demo Version: ") + temp);
					temp.Format(_T("%d"), SDKBits());
					AddGeneralMessage(temp + _T(" Bit SDK"));
					AddGeneralMessage(_T(""));
				}
			}

			delete [] pVersionInfo;
		}
	}

	//Only way to grey out the IP Settings boxes
	EnableGetSetControls(true);
	EnableGetSetControls(false);

	return TRUE;  // return TRUE unless you set the focus to a control
}

//****************************************************************************

void CPrinterSettings::OnBnClickedGetActionRadio()
{
	EnableGetSetControls(FALSE);
}

void CPrinterSettings::OnBnClickedSetActionRadio()
{
	EnableGetSetControls(TRUE);
}

void CPrinterSettings::OnBnClickedBtnGeneralMsgClr()
{
	//Clear the message area
	GeneralMessage.SetWindowText(_T(""));
}

BOOL CPrinterSettings::ActionIsGet()
{
	//Test the 'Action' radio buttons
	return (PrinterAction == 0);
}

//****************************************************************************

void CPrinterSettings::EnableGetSetControls
(
	BOOL bControl
)
{
	//Enable/disable the Get/Set controls
	PrinterAction = bControl;

	EjectModeCombo.EnableWindow(bControl);
	IPModeCombo.EnableWindow(bControl);
	IPAddress.EnableWindow(bControl);
	IPSubnet.EnableWindow(bControl);
	IPGateway.EnableWindow(bControl);
}

//****************************************************************************

void CPrinterSettings::EnableControls
(
	BOOL bControl
)
{
	//Enable/disable controls on the page
	MoveCardBtn.EnableWindow(bControl);
	MoveCardCombo.EnableWindow(bControl);
	CleanBtn.EnableWindow(bControl);
	TestCardBtn.EnableWindow(bControl);
	RestartBtn.EnableWindow(bControl);


	ErrorRespBtn.EnableWindow(bControl);
	ErrorRespCombo.EnableWindow(bControl);

	PrinterGet.EnableWindow(bControl);
	PrinterSet.EnableWindow(bControl);
	EjectModeBtn.EnableWindow(bControl);
	EjectModeCombo.EnableWindow(bControl);
	IPSettingsBtn.EnableWindow(bControl);

	EnableGetSetControls(!ActionIsGet());

	if (bControl)
	{
		//Add other tabs
		Parent->AddPage(InfoPage);
		Parent->AddPage(EncodingPage);
		Parent->AddPage(DriverPage1);
		Parent->AddPage(DriverPage2);
		Parent->AddPage(PrintPage);
		Parent->AddPage(UtilsPage);
	}

	else
	{
		if (Parent->GetPageCount() > 1)
		{
			//Remove other tabs
			Parent->RemovePage(InfoPage);
			Parent->RemovePage(EncodingPage);
			Parent->RemovePage(DriverPage1);
			Parent->RemovePage(DriverPage2);
			Parent->RemovePage(PrintPage);
			Parent->RemovePage(UtilsPage);
		}
	}
}

//****************************************************************************

void CPrinterSettings::AddGeneralMessage
(
	CString pMessage
)
{
	Parent->AddString(&GeneralMessage, pMessage);
}

//****************************************************************************

BYTE CPrinterSettings::SDKBits()
{
	//Get the SDK function address
	PFNIDSDKBITS pFnSDKBits = (PFNIDSDKBITS)GetProcAddress(Parent->hLib, "ID_SDKBits");
	if (!pFnSDKBits)
	{
		FUNCTION_NOT_ACCESSED(SDKBits);
		return FALSE;
	}

	else
	{
		return (*pFnSDKBits)();
	}
}

//****************************************************************************

BOOL CPrinterSettings::PrinterConnected()
{
	PFNIDSTATUS pFnPrinterStatus = (PFNIDSTATUS)GetProcAddress(Parent->hLib, "ID_PrinterStatus");
	if (!pFnPrinterStatus)
	{
		FUNCTION_NOT_ACCESSED(GetPrinterStatus);
		return false;
	}

	else
	{
		//Call the SDK to get the printer status
		CString temp_string;
		switch ((*pFnPrinterStatus)(Parent->hSession))
		{
		case ID_STATUS_READY:	return true;
		case ID_STATUS_OFFLINE: temp_string = _T("Printer is offline");  break;
		case ID_STATUS_ERROR:   temp_string = _T("Printer is in error"); break;
		case ID_STATUS_BUSY:    temp_string = _T("Printer is busy");     break;
		}
		MessageBox(temp_string, MSGBOX_TITLE, MB_OK | MB_ICONINFORMATION );
		return false;
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnOpenSession()
{
	//Display the printer dialog
	CPrintDialog dlg(FALSE);
	dlg.m_pd.Flags &= ~(PD_DISABLEPRINTTOFILE | PD_HIDEPRINTTOFILE);
	if (dlg.DoModal() == IDOK)
	{
		CWaitCursor wait;
		int iEsc = ESC_IS_SDK_CAPABLE;

		PrintPage->PrinterDC    = dlg.GetPrinterDC();
		PrintPage->DeviceName   =
		DriverPage2->DeviceName = dlg.GetDeviceName();

		Parent->PrintToFile = ((dlg.m_pd.Flags & PD_PRINTTOFILE) != 0);

		//Check the selected printer is SDK capable
		int escRes = ExtEscape(dlg.GetPrinterDC(), QUERYESCSUPPORT, sizeof(iEsc), (LPCSTR)&iEsc, 0, NULL);
		if (escRes <= 0)
		{
			MessageBox(_T("OpenPrinter - Error"), MSGBOX_TITLE, MB_OK | MB_ICONSTOP);
		}

		else
		{
			//Get the SDK function address
			PFNIDOPEN pFnOpenSession = (PFNIDOPEN)GetProcAddress(Parent->hLib, "ID_OpenSession");
			if (!pFnOpenSession)
			{
				FUNCTION_NOT_ACCESSED(OpenSession);
			}

			else
			{
				//Start the SDK Session
				ID_RETURN SDKReturn = (*pFnOpenSession)(dlg.GetPrinterDC(), &Parent->hSession, (ID_CONFIG)OpenSessionCombo.GetCurSel());
				if (SDKReturn != ID_SUCCESS)
				{
					DISPLAY_ERROR(OpenSession, SDKReturn);
				}

				else
				{
					//Call the SDK to get the printer type, save it for use elsewhere
					PFNIDPRNTYPE pFnPrinterType = (PFNIDPRNTYPE)GetProcAddress(Parent->hLib, "ID_PrinterType");
					if ((*pFnPrinterType)(Parent->hSession) != ID_ULTIMA)
					{
						MessageBox(_T("Invalid Printer - Ultima Only"), MSGBOX_TITLE, MB_OK | MB_ICONSTOP);
						PFNIDCLOSE pFnCloseSession = (PFNIDCLOSE)GetProcAddress(Parent->hLib, "ID_CloseSession");
						(*pFnCloseSession)(Parent->hSession);
					}
					else
					{
						if (!Parent->PrintToFile)
						{
							IPDATA IPData;
							GetIPSettings(&IPData);
						}

						//Update the display to show the Session is open
						OpenSessionBtn.ShowWindow(FALSE);
						OpenSessionCombo.ShowWindow(FALSE);
						CloseSessionBtn.ShowWindow(TRUE);

						EnableControls(TRUE);
					}
				}
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnCloseSession()
{
	//Get the SDK function address
	PFNIDCLOSE pFnCloseSession = (PFNIDCLOSE)GetProcAddress(Parent->hLib, "ID_CloseSession");
	if (!pFnCloseSession)
	{
		FUNCTION_NOT_ACCESSED(CloseSession);
	}

	else
	{
		// Clean up.
		OpenSessionBtn.ShowWindow(TRUE);
		OpenSessionCombo.ShowWindow(TRUE);
		CloseSessionBtn.ShowWindow(FALSE);
		EnableControls(FALSE);
		EnableGetSetControls(FALSE);

		ID_RETURN SDKReturn = (*pFnCloseSession)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(CloseSession, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnErrorResponse()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDRESPONSE pFnErrorResponse = (PFNIDRESPONSE)GetProcAddress(Parent->hLib, "ID_ErrorResponse");
	if (!pFnErrorResponse)
	{
		FUNCTION_NOT_ACCESSED(ErrorResponse);
	}

	else
	{
		//Call SDK to send the selected Error Response to the printer
		ID_RETURN SDKReturn = (*pFnErrorResponse)(Parent->hSession, (ID_RESPONSE)ErrorRespCombo.GetCurSel());
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(ErrorResponse, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnMoveCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDMOVE pFnMoveCard = (PFNIDMOVE)GetProcAddress(Parent->hLib, "ID_MoveCard");
	if (!pFnMoveCard)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		ID_RETURN SDKReturn = (*pFnMoveCard)(Parent->hSession, (ID_CARD_POSITION)MoveCardCombo.GetCurSel());
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(MoveCard, SDKReturn);
		}
		else
		{
			//Wait for the card to be moved into place
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(MoveCardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnCleanPrinter()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDCLEAN pFnCleanPrinter = (PFNIDCLEAN)GetProcAddress(Parent->hLib, "ID_CleanPrinter");
	if (!pFnCleanPrinter)
	{
		FUNCTION_NOT_ACCESSED(CleanPrinter);
	}

	else
	{
		//Call SDK to Clean the printer
		ID_RETURN SDKReturn = (*pFnCleanPrinter)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(CleanPrinter, SDKReturn);
		}

		else
		{
			//Wait for the clean cycle to be completed
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(CleanPrinterWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnRestartPrinter()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDRESTART pFnRestartPrinter = (PFNIDRESTART)GetProcAddress(Parent->hLib, "ID_RestartPrinter");
	if (!pFnRestartPrinter)
	{
		FUNCTION_NOT_ACCESSED(RestartPrinter);
	}

	else
	{
		//Call SDK to Restart the printer
		ID_RETURN SDKReturn = (*pFnRestartPrinter)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(RestartPrinter, SDKReturn);
		}

		else
		{
			//Wait for the printer to restart
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(RestartPrinterWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnPrintTestCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDPRINTTEST pFnPrintTestCard = (PFNIDPRINTTEST)GetProcAddress(Parent->hLib, "ID_PrintTestCard");
	if (!pFnPrintTestCard)
	{
		FUNCTION_NOT_ACCESSED(PrintTestCard);
	}

	else
	{
		//Call SDK to Print a Test Card
		ID_RETURN SDKReturn = (*pFnPrintTestCard)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(PrintTestCard, SDKReturn);
		}

		else
		{
			//Wait for the test card to be printed
			SDKReturn = Parent->WaitForPrinterToPrint();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(PrintTestCardWait, SDKReturn);
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::EjectModeToMsgBox
(
	ID_EJECTMODE Mode,
	ID_READWRITE Action
)
{
	//Update the message box with the Eject Mode status
	AddGeneralMessage(_T("EjectMode") + Parent->Separator(Action) + Parent->OnOffString(Mode));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetEjectModeBox
(
	ID_EJECTMODE mode
)
{
	//Update the Eject Mode control
	EjectModeCombo.SetCurSel(mode);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetEjectMode
(
	PID_EJECTMODE Mode
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDEJECTMODE pFnEjectMode = (PFNIDEJECTMODE)GetProcAddress(Parent->hLib, "ID_EjectMode");
	if (!pFnEjectMode)
	{
		FUNCTION_NOT_ACCESSED(GetEjectMode);
	}

	else
	{
		// Call the SDK to read the Eject Mode status
		SDKReturn = (*pFnEjectMode)(Parent->hSession, ID_READ, Mode);
		if (SDKReturn == ID_SUCCESS)
		{
			SetEjectModeBox(*Mode);
		}
		else
		{
			DISPLAY_ERROR(GetEjectMode, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnEjectMode()
{
	CWaitCursor wait;
	ID_EJECTMODE Mode;

	if (ActionIsGet())
	{
		//Get the Eject Mode status
		if (GetEjectMode(&Mode) == ID_SUCCESS)
		{
			EjectModeToMsgBox(Mode, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDEJECTMODE pFnEjectMode = (PFNIDEJECTMODE)GetProcAddress(Parent->hLib, "ID_EjectMode");
		if (!pFnEjectMode)
		{
			FUNCTION_NOT_ACCESSED(GetEjectMode);
		}

		else
		{
			//Get the selected Eject Mode status
			Mode = (ID_EJECTMODE)EjectModeCombo.GetCurSel();

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnEjectMode)(Parent->hSession, ID_WRITE, &Mode);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(GetEjectMode, SDKReturn);
			}
			else
			{
				//Update the message box
				EjectModeToMsgBox(Mode, ID_WRITE);
			}
		}
	}
}
//#############################################################################

void CPrinterSettings::IPSettingsToMsgBox
(
	PIPDATA      pIPData,
	ID_READWRITE Action
)
{
	CString sep = Parent->Separator(Action);

	//Update the message box with the IP Settings status
	CString temp_string = pIPData->IPAddressMode ? _T("Dynamic") : _T("Static");
	AddGeneralMessage(_T("Address Mode") + sep + temp_string);

	temp_string.Format(_T("%02x:%02x:%02x:%02x:%02x:%02x"), 
						(pIPData->MACAddrHi & 0x00ff0000) >> 16,
						(pIPData->MACAddrHi & 0x0000ff00) >> 8,
						(pIPData->MACAddrHi & 0x000000ff),
						(pIPData->MACAddrLo & 0x00ff0000) >> 16,
						(pIPData->MACAddrLo & 0x0000ff00) >> 8,
						(pIPData->MACAddrLo & 0x000000ff));
	AddGeneralMessage(_T("MAC Address ") + temp_string + "\n");

	in_addr temp;
	temp.S_un.S_addr = htonl(pIPData->IPAddress);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("IP Address") + sep + temp_string + "\n");

	temp.S_un.S_addr = htonl(pIPData->SubnetMask);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("Subnet Mask") + sep + temp_string + "\n");

	temp.S_un.S_addr = htonl(pIPData->Gateway);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("Gateway") + sep + temp_string + "\n");

	AddGeneralMessage(_T(""));
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetIPSettings
(
	PIPDATA pIPData
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDIPSETTINGS pFnIPSettings = (PFNIDIPSETTINGS)GetProcAddress(Parent->hLib, "ID_IPSettings");
	if (!pFnIPSettings)
	{
		FUNCTION_NOT_ACCESSED(GetIPSettings);
	}

	else
	{
		// Call the SDK to read the IP Settings
		SDKReturn = (*pFnIPSettings)(Parent->hSession, ID_READ, pIPData);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetIPSettings, SDKReturn);
		}
		else
		{
			//Update the IP Settings controls
			IPModeCombo.SetCurSel(pIPData->IPAddressMode);

			in_addr temp;
			temp.S_un.S_addr = ntohl(pIPData->IPAddress);
			IPAddress.SetAddress(temp.S_un.S_un_b.s_b1,
								 temp.S_un.S_un_b.s_b2,
								 temp.S_un.S_un_b.s_b3,
								 temp.S_un.S_un_b.s_b4);
			temp.S_un.S_addr = ntohl(pIPData->SubnetMask);
			IPSubnet.SetAddress(temp.S_un.S_un_b.s_b1,
								 temp.S_un.S_un_b.s_b2,
								 temp.S_un.S_un_b.s_b3,
								 temp.S_un.S_un_b.s_b4);
			temp.S_un.S_addr = ntohl(pIPData->Gateway);
			IPGateway.SetAddress(temp.S_un.S_un_b.s_b1, 
								 temp.S_un.S_un_b.s_b2, 
								 temp.S_un.S_un_b.s_b3, 
								 temp.S_un.S_un_b.s_b4);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnIPSettings()
{
	IPDATA IPData = {};
	CWaitCursor wait;

	if (ActionIsGet())
	{
		//Get the ethernet IP settings
		if (GetIPSettings(&IPData) == ID_SUCCESS)
		{
			IPSettingsToMsgBox(&IPData, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDIPSETTINGS pFnIPSettings = (PFNIDIPSETTINGS)GetProcAddress(Parent->hLib, "ID_IPSettings");
		if (!pFnIPSettings)
		{
			FUNCTION_NOT_ACCESSED(SetIPSettings);
		}

		else
		{
			//Get the selected ethernet IP settings
			BYTE add1, add2, add3, add4;
			char addr_string[20];

			GetIPSettings(&IPData); //Initialise structure - for MAC Address

			IPData.IPAddressMode = IPModeCombo.GetCurSel() ? ID_DYNAMIC : ID_STATIC;
		
			IPAddress.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
 			IPData.IPAddress = htonl(inet_addr(addr_string));

			IPSubnet.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
			IPData.SubnetMask = htonl(inet_addr(addr_string));

			IPGateway.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
			IPData.Gateway = htonl(inet_addr(addr_string));

			//Call the SDK to update them
			ID_RETURN SDKReturn = (*pFnIPSettings)(Parent->hSession, ID_WRITE, &IPData);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetIPSettings, SDKReturn);
			}
			else
			{
				//Update the message box
				IPSettingsToMsgBox(&IPData, ID_WRITE);
			}
		}
	}
}

